<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>System Monitor</title>
<link rel="stylesheet" type="text/css" href="../style/default.css" />
<style type=text/css>
	.body_width
	{
		width: 320px;
	}
    .tab_width
    {
        width: 300px;
    }
</style>
<script type="text/javascript" src="../js/browserdetect.js"></script>
<script type="text/javascript" src="../js/smsx_common.js"></script>
</head>

<body>
<input type="hidden" id="language" value="0" />
<div class="body_div tableContainer body_width">
	<div style="margin-top: 10px">
		<input id="TempInF" name="TempInF" type="checkbox" onclick="OnFClick()" />Display temperature in &deg;F
	</div>
    <div id="temperat_div">
    <div class="table_tab_div">
        <div class="table_tab_left"></div>
        <div class="table_tab tab_width">Temperatures</div>
        <div class="table_tab_right"></div>
	</div>
	<table id="temperat_table" cellpadding="0" cellspacing="0" width="100%">
		<tr>
			<th width="160" nowrap="nowrap">Device</th>
			<th width="160" nowrap="nowrap" id="DeviceTemperature">Temperature (&deg;C)</th>
		</tr>
	</table>
    </div>
    <div id="power_div">
    <div class="table_tab_div">
        <div class="table_tab_left"></div>
        <div class="table_tab tab_width">Voltages</div>
        <div class="table_tab_right"></div>
	</div>
	<table id="power_table" cellpadding="0" cellspacing="0" width="100%">
		<tr>
			<th width="160" scope="col" nowrap="nowrap">Power Supply</th>
			<th width="160" nowrap="nowrap" scope="col">Actual Voltage(V)</th>
		</tr>
	</table>
    </div>
    <div id="fan_div">
    <div class="table_tab_div">
        <div class="table_tab_left"></div>
        <div class="table_tab tab_width">Fans</div>
        <div class="table_tab_right"></div>
	</div>
	<table id="fan_table" cellpadding="0" cellspacing="0" width="100%">
		<tr>
			<th width="160" scope="col" nowrap="nowrap">Fan</th>
			<th width="160" nowrap="nowrap" scope="col">Tachometer (RPM)</th>
		</tr>
	</table>
    </div>
</div>
<script type="text/javascript">
var DISPLAY = 1;
var NO_DISPLAY = 0;
var NUM_COLUMNS = 2;
var CARD_NUM = 4;
var POWER_NUM = 3;
var FAN_NUM = 4;
var divCtrlId = new Array("temperat_div", "power_div", "fan_div");
var tableCtrlId = new Array("temperat_table", "power_table", "fan_table");
var i;
	
var tempCelsius = new Array(CARD_NUM);

function C2F(Celcius)
{
	var Farenheit = 9 * Celcius / 5 + 32;
	return Farenheit;
}
	
function OnFClick()
{
	var idx;
	var table = document.getElementById("temperat_table");

	if(document.getElementById("TempInF").checked == true)
	{
		document.getElementById("DeviceTemperature").innerHTML = "Temperature (&deg;F)";
		for(i = 0; i < CARD_NUM; i++)
		{
			idx = i + 1;
			table.rows[idx].cells[1].innerHTML = C2F(tempCelsius[i]);
		}
	}
	else
	{
		document.getElementById("DeviceTemperature").innerHTML = "Temperature (&deg;C)";
		for(i = 0; i < CARD_NUM; i++)
		{
			idx = i + 1;
			table.rows[idx].cells[1].innerHTML = tempCelsius[i];
		}
	}
}
	
function AddRows(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	
	for(i = 0; i < rowNum; i++)
	{
		var row = table.insertRow(i + 1);

		for(var j = 0; j < NUM_COLUMNS; j++)
		{
			var cell = row.insertCell(j);
		}
	}
}
	
function UpdateRowData(table, rowID, rowData)
{
	var cell;

	for(i = 0; i < NUM_COLUMNS; i++)
	{		
		cell = table.rows[rowID].cells[i];
		cell.innerHTML = rowData[i];
	}
}

function fillTable(data)
{
	var idx = 0;
	var DevInfo = data.split("|");
	var tempInfo;
	var rowNum;
	
	for(idx; idx<DevInfo.length; idx++)
	{
		tempInfo = DevInfo[idx].split("&");
		if(tempInfo[0] == NO_DISPLAY)
		{
			document.getElementById(divCtrlId[idx]).style.display = "none";
		}
		else
		{
			rowNum = tempInfo[1];
			AddRows(tableCtrlId[idx], rowNum);
			
			for(var j = 0; j < rowNum; j++)
			{
				var rowData = tempInfo[j + 2].split(",");
				UpdateRowData(document.getElementById(tableCtrlId[idx]), (j + 1), rowData);
				
				if(idx == 0)
				{
					tempCelsius[j] = rowData[1];
				}
			}
			
			if(idx == 0)
			{
				CARD_NUM = tempInfo[1];
			}
		}
	}
}

function getDeviceInfo()
{
	var aHttpObject = getHTTPObject();
	var getParams = "type=28&cmd=1&getSystemInfo=1&language=" + document.getElementById("language").value;
  
	aHttpObject.open("POST", "/goform/formIPQAM", true);
	aHttpObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	aHttpObject.setRequestHeader("Content-length", getParams.length);
	if(bd.browser != "IE")
	{
		aHttpObject.overrideMimeType("text/html;charset=gb2312");
	}
	aHttpObject.onreadystatechange = function()
	{
		if(aHttpObject.readyState == 4)
		{
			var Response;
			if(bd.browser == "IE")
			{
				Response = gb2utf8(aHttpObject.responseBody);
				var index = Response.indexOf("</html>");
				var bias = Response.length - index;
				Response = Response.slice(7, - bias);
			}
			else
			{
				Response = aHttpObject.responseText.slice(7, -8);
			}
			
			fillTable(Response);
		}
	}
	aHttpObject.send(getParams);
	return true;
}

function PageLoadHandler()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	getDeviceInfo();
	document.body.style.cursor = "auto";
	window.status = "Done";
}
window.onload = function()
{
	PageLoadHandler();
}
</script>

</body>
</html>
